# VC++ 6.0 Makefile for SQLite3 ODBC driver                  -*- Makefile -*-
#
#

ROOT    = .
SRCDIR  = $(ROOT)

!ifndef DEBUG
DEBUG = 0
!endif DEBUG
!ifndef PROFILE
PROFILE = 0
!endif
!ifndef SYMBOLS
SYMBOLS = 0
!endif

!if $(DEBUG)
OUTDIR =Debug
CFLAGS =-Od -Zi -GZ -MDd -D_DEBUG
LDFLAGS=-debug:full -debugtype:cv
!else
OUTDIR =Release
!if $(SYMBOLS)
CFLAGS =-Od -Zi -Op -Gs -MD -DNDEBUG=1
LDFLAGS=-debug -opt:ref -opt:icf,3
!else
CFLAGS =-O2 -Op -Gs -MD -DNDEBUG=1
LDFLAGS=-release -opt:ref -opt:icf,3
!endif
!endif

!if $(PROFILE)
CFLAGS =$(CFLAGS) -Zi
LDFLAGS=$(LDFLAGS) -profile -map
!endif

TMPDIR =$(OUTDIR)\OdbcObjects

LIBSQLITE=$(OUTDIR)\libsqlite3.lib

CC     =cl -nologo
LD     =link -nologo
AR     =lib -nologo
RC     =rc
AWK    =awk
COPY   =copy
RMDIR  =rmdir /s /q

CFLAGS =$(CFLAGS) -W3 -GX -YX -Fp$(TMPDIR)^\
INC    =-I$(SRCDIR) -I$(OUTDIR) -I$(TMPDIR)
DEFS   =-D_WIN32 -DOS_WIN=1 -D_DLL -DHAVE_SQLITEATOF=1
LIBS   =odbccp32.lib comdlg32.lib user32.lib

#-------------------------------------------------------------------------

OBJECTS =$(TMPDIR)\sqlite3odbc.obj

all: setup $(OUTDIR)\sqlite3odbc.dll $(OUTDIR)\inst.exe \
	$(OUTDIR)\uninst.exe $(OUTDIR)\adddsn.exe \
	$(OUTDIR)\remdsn.exe $(OUTDIR)\addsysdsn.exe $(OUTDIR)\remsysdsn.exe

$(OUTDIR)\sqlite3odbc.dll: $(LIBSQLITE) $(OBJECTS) $(TMPDIR)\sqlite3odbc.res
	$(LD) -dll -out:$@ $(LDFLAGS) $(OBJECTS) $(TMPDIR)\sqlite3odbc.res \
	-def:$(SRCDIR)\sqlite3odbc.def $(LIBSQLITE) $(LIBS)

$(OUTDIR)\inst.exe: $(SRCDIR)\inst.c
	$(CC) $(CFLAGS) -o $@ -Fo$(TMPDIR)\ inst.c $(LIBS)

$(OUTDIR)\adddsn.exe: $(SRCDIR)\adddsn.c
	$(CC) $(CFLAGS) -o $@ -Fo$(TMPDIR)\ adddsn.c $(LIBS)

$(OUTDIR)\uninst.exe: $(OUTDIR)\inst.exe
	@$(COPY) $** $@ >NUL

$(OUTDIR)\remdsn.exe: $(OUTDIR)\adddsn.exe
	@$(COPY) $** $@ >NUL

$(OUTDIR)\remsysdsn.exe: $(OUTDIR)\adddsn.exe
	@$(COPY) $** $@ >NUL

$(OUTDIR)\addsysdsn.exe: $(OUTDIR)\adddsn.exe
	@$(COPY) $** $@ >NUL

$(SRCDIR)\sqlite3odbc.c: $(TMPDIR)\resource.h

$(TMPDIR)\sqlite3odbc.res: $(SRCDIR)\sqlite3odbc.rc $(TMPDIR)\resource.h
	$(RC) -I. -I$(OUTDIR) -I$(TMPDIR) -fo $@ -r $(SRCDIR)\sqlite3odbc.rc

$(TMPDIR)\VERSION_C: $(SRCDIR)\VERSION $(TMPDIR)\fixup.exe
	$(TMPDIR)\fixup < $(SRCDIR)\VERSION > $@ . ,

$(TMPDIR)\resource.h: $(SRCDIR)\resource.h.in $(TMPDIR)\VERSION_C
	$(TMPDIR)\fixup < $(SRCDIR)\resource.h.in > $@ \
	    --VERS-- @$(SRCDIR)\VERSION \
	    --VERS_C-- @$(TMPDIR)\VERSION_C

$(LIBSQLITE): $(SRCDIR)\sqlite3.mak
	@nmake -nologo -f $(SRCDIR)\sqlite3.mak

#-------------------------------------------------------------------------

$(TMPDIR)\fixup.exe: $(SRCDIR)\fixup.c
	$(CC) $(CFLAG) -o $@ -Fo$(TMPDIR)\ $**

$(TMPDIR)\mkopc.exe: $(SRCDIR)\mkopc.c
	$(CC) $(CFLAGS) -o $@ -Fo$(TMPDIR)\ $**

#-------------------------------------------------------------------------

.SUFFIXES: .c

{$(SRCDIR)}.c{$(TMPDIR)}.obj::
        $(CC) $(CFLAGS) $(INC) $(DEFS) -Fo$(TMPDIR)\ -c @<<
$<
<<

#-------------------------------------------------------------------------

setup:
        @if not exist $(OUTDIR) mkdir $(OUTDIR)
        @if not exist $(TMPDIR) mkdir $(TMPDIR)

clean:
	@if exist $(TMPDIR) $(RMDIR) $(TMPDIR) >NUL
	@if exist $(TMPSRC) $(RMDIR) $(TMPSRC) >NUL

realclean:
	@if exist $(OUTDIR) $(RMDIR) $(OUTDIR) >NUL
