if {[file exists tclresolver.dll]} {
    load tclresolver.dll Tclresolver
} else {
    package require Tclresolver
}

set hostname [info hostname]
set uid 0

proc every {aidname n args} {
    upvar #0 $aidname aid
    catch $args
    set aid [after $n [eval list every $aidname $n $args]]
}

proc display {s} {
    if {[info exists ::tk_library]} {
        .t insert end $s
        .t see end
    } else {
        puts -nonewline $s ; flush stdout
    }
}

proc lookup {} {
    global hostname
    set aidname ::aid[incr ::uid]
    upvar $aidname aid
    every $aidname 25 display .
    set ips [resolve $hostname]
    after cancel $aid
    unset aid
    display "\n$ips\n"
}
    
proc gui {} {
    wm title . "Tclresolver [package provide Tclresolver]"

    frame .f
    label .l -text Hostname -underline 0
    entry .e -textvariable ::hostname
    button .h -text Lookup -width -12 -underline 0 -command lookup \
        -default active
    button .x -text Exit   -width -12 -underline 1 -command {destroy .}
    text .t -yscrollcommand {.s set} -height 10
    scrollbar .s -command {.t yview}

    pack .l -in .f -side left
    pack .e -in .f -side left -expand 1 -fill x -padx 4
    pack .h .x -in .f -side left

    grid .t .s -sticky news
    grid .f  - -sticky news
    grid rowconfigure . 0 -weight 1
    grid columnconfigure . 0 -weight 1

    bind . <Alt-h> {focus .e}
    bind . <Alt-l> {focus .h}
    bind . <Alt-x> {focus .x}
    bind . <Return> {.h invoke}
    bind . <Escape> {.x invoke}
    if {[string equal [tk windowingsystem] "win32"]} {
        bind . <Control-o> {console show}
    }

    tkwait visibility .t
    after 100 {set ::wait 1} ; tkwait variable ::wait
    focus .e
    tkwait window .
    return
}


if {[package provide Tk] != {}} {
    gui
} else {
    puts "tclresolver [package provide Tclresolver]"
    set hostname [lindex $argv 0]
    lookup
}
