#
#
#

set root [file dirname [info script]]
source [file join $root s2s.tcl]
package require xmppd::s2s
namespace import -force xmppd::s2s::*

# -------------------------------------------------------------------------
# Application level:
# The s2s server routes incoming messages to the -handler configuration proc.
# This is a demo.
#
proc Handler {type attributes close value children} {

    switch -exact -- $type {
        message {
            array set attr $attributes
            set msg [lindex [wrapper::gettag $children] 3]
            puts "$attr(from) -> $attr(to) \[$attr(type)\]\n  $msg"
        }
        presence {
            array set attr {type {}}
            array set attr $attributes
            switch -exact -- $type {
                subscribe {
                    # NB: servers should not do this.
                    xmppd::s2s::route \
                        -from $attr(to) -to $attr(from) \
                        "<presence xmlns='jabber:client'\
                          from='$attr(to)' to='attr(from)'\
                          type='subscribed' />"
                }
                default {
                    set show "online"
                    set status ""
                    foreach xml $children {
                        switch -exact -- [wrapper::gettag $xml] {
                            show   { set show   [wrapper::getcdata $xml] }
                            status { set status [wrapper::getcdata $xml] }
                        }
                    }
                    if {$status ne {}} {append show " ($status)"}
                    puts "$attr(from) -> $attr(to) \[$show\]"
                }
            }
        }
        default {
            xmppd::s2s::Log debug "$type $attributes $close $value $children"
        }
    }
}

#{from patthoyts@bugzilla.renishaw.com/tkabber xml:lang en-GB type chat to patthoyts@uknml2375.renishaw.com/test xmlns jabber:client} 0 {} {{body {} 0 hehe {}} {x {xmlns jabber:x:event} 0 {} {{offline {} 1 {} {}} {delivered {} 1 {} {}} {displayed {} 1 {} {}} {composing {} 1 {} {}}}}}


#{from patthoyts@bugzilla.renishaw.com/tkabber id 37 xml:lang en-GB type get to patthoyts@uknml2375.renishaw.com/test xmlns jabber:client} 0 {} {{query {xmlns jabber:iq:version} 1 {} {}}}


# -------------------------------------------------------------------------

set client conference.patthoyts.tk
set server tach.tclers.tk
set who    test

proc presence2 {type {show {}} {status {}} {user {patthoyts}} {nick {}}} {
    global client server who
    
    set kids {}
    lappend kids [list x {xmlns http://jabber.org/protocols/muc} 1 "" {}]
    if {$show ne {}} {
        lappend kids [list show {} 0 $show {}]
    }
    if {$status ne {}} {
        lappend kids [list status {
            xmlns:xml http://www.w3.org/XML/1998/namespace
            xml:lang en-GB
        } 0 $status {}]
    }
    if {$nick eq {}} {set nick $user}
    set attr [list from "${user}@${client}/test" \
                  to "${who}@${server}/${nick}" type "$type"]

    set xml [wrapper::createxml [list presence $attr 0 "" $kids]]
    puts [wrapper::createxml [list presence $attr 0 "" $kids]]
    xmppd::s2s::route -from $client -to $server $xml
    return
}

proc say2 {msg {type groupchat} {user patthoyts}} {
    global client server who
    xmppd::s2s::route -from $client -to $server \
        "<message from='$user@${client}/test'\
               to='${who}@${server}' type='$type'>\
               <body>[wrapper::xmlcrypt $msg]</body></message>"
}

proc presence {type {show {}}} {
    global client server who
    xmppd::s2s::route -from $client -to $server \
        "<presence from='patthoyts@${client}/test'\
               to='${who}@${server}/s2s_test' type='$type'><x\
               xmlns='http://jabber.org/protocols/muc'/></presence>"
}

proc say {msg {type groupchat}} {
    global client server who
    xmppd::s2s::route -from $client -to $server \
        "<message from='patthoyts@${client}/test'\
               to='${who}@${server}' type='$type'>\
               <body>[wrapper::xmlcrypt $msg]</body></message>"
}


if {0} {
    set client uknml2375.renishaw.com
    set server bugzilla.renishaw.com
    set who    patthoyts

    proc presence {type} {
        global client server who
        xmppd::s2s::route -from $client -to $server \
            "<presence from='patthoyts@${client}/test'\
               to='${who}@${server}' type='$type'/>"
    }
    proc say {msg {type chat}} {
        global client server who
        xmppd::s2s::route -from $client -to $server \
            "<message from='patthoyts@${client}/test'\
               to='${who}@${server}' type='$type'>\
               <body>[wrapper::xmlcrypt $msg]</body></message>"
    }

}

# -------------------------------------------------------------------------

xmppd::s2s::configure -jid $client -handler ::Handler
catch {xmppd::s2s::start}

